/*
  Hud messages for Bombing Run.
  
  Author Mark Caldwell aka W@rHe@d of The Reliquary
 */
class UTBRHUDMessage extends UTLocalMessage;

var(Message) localized string YouHaveBallString;
var(Message) localized string YourTeamHasBallString;
var(Message) localized string EnemyHasBallString;
var(Message) localized string IncomingPassString;

var(Message) color RedColor, YellowColor;

static function color GetColor(
	optional int Switch,
	optional PlayerReplicationInfo RelatedPRI_1,
	optional PlayerReplicationInfo RelatedPRI_2,
	optional Object OptionalObject
	)
{
	if (Switch != 1)
		return Default.YellowColor;
	else
		return Default.RedColor;
}

static function string GetString(
	optional int Switch,
	optional bool bPRI1HUD,
	optional PlayerReplicationInfo RelatedPRI_1,
	optional PlayerReplicationInfo RelatedPRI_2,
	optional Object OptionalObject
	)
{
	if (Switch < 0)
	{
		return string(0 - switch) $ "...";
	}
	
	if ( Switch == 0 )
	    return Default.YouHaveBallString;
    else if ( Switch == 1 )
	    return Default.EnemyHasBallString;
	else if ( Switch == 2 )
	    return Default.YourTeamHasBallString;
	else if (Switch == 3 )
	    return Default.IncomingPassString;
	else
		return "";
}

static function bool AddAnnouncement(UTAnnouncer Announcer, int MessageIndex, optional PlayerReplicationInfo PRI, optional Object OptionalObject) {}

defaultproperties
{
   YouHaveBallString="You have the orb, take it to enemy goal!"
   YourTeamHasBallString="Your team has the orb, take it to enemy goal!"
   EnemyHasBallString="The enemy has the orb, recover it!"
   IncomingPassString="Incoming Pass!"
   RedColor=(B=0,G=0,R=255,A=255)
   YellowColor=(B=0,G=255,R=255,A=255)
   MessageArea=0
   bIsUnique=True
   bIsConsoleMessage=False
   Lifetime=1.000000
   DrawColor=(B=255,G=160,R=0,A=255)
   FontSize=1
   Name="Default__UTBRHUDMessage"
   ObjectArchetype=UTLocalMessage'UTGame.Default__UTLocalMessage'
}
